//
//  MCReportConverter.h
//  BIViews
//
//  Created by Mark Onyschuk on 24/04/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCReportConverter : NSWindowController {
	NSOpenPanel *openPanel;
	NSString	*desiredType;
	
	IBOutlet	NSProgressIndicator *progressIndicator;
}

+ (id)sharedConverter;

/*!
 Converts a bunch of templates. Callers much ensure that the source folder is readable and the destination folder is writable. Returns an array of errors (strings) if errors or warnings are encountered during the conversion process
 
 */
+ (NSArray *)convertTemplatesTo3xFromFolder:(NSString *)sourceFolder 
						toDestinationFolder:(NSString *)destFolder;



/*!
 Generic way to convert a bunch of templates from one document type to another by calling convSelector on the document. convSelector takes no arguments and returns an array (could be nil).
 
 NSArray *errors = [[self class] convertTemplatesFromFolder:source 
 						sourceExtension:@"bitemplate3"
 						sourceDocType:@"Billings 3 Legacy Report"
 						toDestinationFolder:destination
						destinationExtension:@"bptemplate"
 						destinationDocType:@"Billings Pro Report"
 						conversionSelector:@selector(convertFromBI3xToBP1xWithoutRefreshingWindows)];
 
 
 Returns an array of NSErrors if any.
 
 */
+ (NSArray *)convertTemplatesFromFolder:(NSString *)sourceFolder 
						sourceExtension:(NSString *)sourceExt
						  sourceDocType:(NSString *)sourceDocType
					toDestinationFolder:(NSString *)destFolder 
				   destinationExtension:(NSString *)destExt
					 destinationDocType:(NSString *)destDocType
					 conversionSelector:(SEL)convSelector;


#pragma mark -
#pragma mark Accessors
- (NSString *)desiredType;
- (void)setDesiredType:(NSString *)aString; // Invoice or Estimate

#pragma mark -
#pragma mark Conversion
- (IBAction)openAndConvertInvoiceToEstimate:(id)sender;
- (IBAction)openAndConvertInvoiceToStatement:(id)sender;
- (IBAction)openAndConvertTo3xReport:(id)sender;
- (IBAction)bulkConvertTo3x:(id)sender;
- (IBAction)bulkConvertFromBI3xToBP1x:(id)sender;

/*!
 Expects sourcePath and destinationPath to exist.
 Returns an array of NSError, nil if everything is good.
 */
- (NSArray *)bulkConvertFromBI3xToBP1xFromSource:(NSString *)sourcePath 
								   toDestination:(NSString *)destinationPath;


#pragma mark -
#pragma mark Progress Window
- (void)showProgressWindow;
- (void)hideProgressWindow;

@end
